/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.inventory.personalstorage;

import fr.iglee42.evolvedmekanism.EvolvedMekanism;
import fr.iglee42.evolvedmekanism.inventory.personalstorage.TieredPersonalStorageItemInventory;
import fr.iglee42.evolvedmekanism.tiers.PersonalStorageTier;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.lib.MekanismSavedData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
class TieredPersonalStorageData
extends MekanismSavedData {
    private final Map<UUID, TieredPersonalStorageItemInventory> inventoriesById = new HashMap<UUID, TieredPersonalStorageItemInventory>();

    TieredPersonalStorageData() {
    }

    TieredPersonalStorageItemInventory getOrAddInventory(UUID id, PersonalStorageTier tier) {
        return this.inventoriesById.computeIfAbsent(id, unused -> this.createInventory(tier));
    }

    void removeInventory(UUID id) {
        if (this.inventoriesById.remove(id) != null) {
            this.m_77762_();
        }
    }

    @NotNull
    private TieredPersonalStorageItemInventory createInventory(PersonalStorageTier tier) {
        return new TieredPersonalStorageItemInventory(tier, () -> ((TieredPersonalStorageData)this).m_77762_());
    }

    public void load(@NotNull CompoundTag nbt) {
        ListTag entries = nbt.m_128437_("data", 10);
        for (int i = 0; i < entries.size(); ++i) {
            CompoundTag entry = entries.m_128728_(i);
            PersonalStorageTier tier = PersonalStorageTier.values()[entry.m_128451_("tier")];
            TieredPersonalStorageItemInventory inv = this.createInventory(tier);
            inv.deserializeNBT(entry.m_128437_("Items", 10));
            this.inventoriesById.put(entry.m_128342_("personalStorageId"), inv);
        }
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag entries = new ListTag();
        this.inventoriesById.forEach((uuid, inv) -> {
            CompoundTag nbtEntry = new CompoundTag();
            nbtEntry.m_128362_("personalStorageId", uuid);
            nbtEntry.m_128365_("Items", (Tag)inv.serializeNBT());
            nbtEntry.m_128405_("tier", inv.getTier().ordinal());
            entries.add((Object)nbtEntry);
        });
        compoundTag.m_128365_("data", (Tag)entries);
        return compoundTag;
    }

    public void m_77757_(File file) {
        File folder;
        if (this.m_77764_() && !(folder = file.getParentFile()).exists() && !folder.mkdirs()) {
            EvolvedMekanism.logger.error("Could not create personal storage directory, saves may fail");
        }
        super.m_77757_(file);
    }
}

